/**
 * third party libraries
 */
const bodyParser = require('body-parser');
const express = require('express');
const helmet = require('helmet');
const http = require('http');
const cors = require('cors');
const _ = require('lodash');


/**
 * Swagger UI Configuration
 */

/* const swaggerJSDoc = require('swagger-jsdoc');
const swaggerUi = require('swagger-ui-express');

const swaggerDefinition = {
  info: {
    title: 'Welcome to Signity School Of Engineering!',
    version: '1.0.0',
    description: 'Endpoints to test APIs',
  },
  host: 'localhost:2017',
  basePath: '/',
  securityDefinitions: {
    bearerAuth: {
      type: 'apiKey',
      name: 'Authorization',
      scheme: 'bearer',
      in: 'header',
    },
  },
};

const options = {
  swaggerDefinition,
  apis: ['api/routes/*.js'],
};

const swaggerSpec = swaggerJSDoc(options); */

/**
 * server configuration
 */
const config = require('../config/');
const dbService = require('../services/db.service');

// environment: development, staging, testing, production
const environment = process.env.NODE_ENV;
console.log(environment);
/**
 * express application
 */
const app = express();
const server = http.Server(app);

const DB = dbService(environment, config.migrate).start();




/**
 * Configure Routes
 */
require('./routes').set_routes(app);
app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(swaggerSpec));

/* server.listen(config.port, () => {
  if (environment !== 'production' &&
    environment !== 'development' &&
    environment !== 'testing'
  ) {
    console.error(`NODE_ENV is set to ${environment}, but only production and development are valid.`);
    process.exit(1);
  }
  return DB;
}); */
