const User = require('../models/User');
const UsersDailySteps = require('../models/UsersDailySteps');
const UsersDailyAdds = require('../models/UsersDailyAdds');
const UserTokens = require('../models/UserTokens');
const TokenMintHistory = require('../models/TokenMintHistory');
const TotalIssuesToken = require('../models/TotalIssuesToken');
const UserWithdrawals = require('../models/UserWithdrawals');
const Tokenomics = require('../models/Tokenomics');

const authService = require('../../services/auth.service');
const helperService = require('../../services/helpers.service');
const emailService = require('../../services/email.service');
const Sequelize = require('sequelize');

const { includes } = require('lodash');

exports.home = async (req,res) => {
      const date = new Date();
      var success = req.flash('success');
      var error = req.flash('failer');
      const Active_User = await User.count({
            distinct: true,
            where:{
               status: 1,
               account_status: {
                  [Sequelize.Op.lt]: 2
               },
               is_verify: 1
            }
      })
      const totalIssuesToken = await TotalIssuesToken.findOne({
            attributes: [ "total_issued"]
      });

      withdraw = await TokenMintHistory.findAll({
            attributes: [ "date", [Sequelize.fn('sum', Sequelize.col('quantity')), 'total_quantity'] ],
            group: "date",
            raw: true
      });
      total_quantity = []
      withdraw.map(itm => {
            total_quantity.push(itm.total_quantity)
      })
      res.render('home', { totalUsers: Active_User, totalTokens: totalIssuesToken, withdraw: total_quantity, success: success, errors: error, date : date})
};
exports.ajaxDashboard = async (req, res) => {
      try {
          const { type } = req.query;
          if(type != ""){
              if(type == "day"){
                  const withdraw = await TokenMintHistory.findAll({
                        attributes: [ "date", [Sequelize.fn('sum', Sequelize.col('quantity')), 'total_quantity'] ],
                        group: "date",
                        raw: true
                  });
                  let total_quantity = []
                  withdraw.map(itm => {
                        total_quantity.push(itm.total_quantity)
                  })
                  res.status(200).json(total_quantity);
              }else if(type == "week"){
                  const withdraw = await TokenMintHistory.findAll({
                        attributes: [ 
                              [Sequelize.fn('WEEK', Sequelize.col('created_at')), 'week'],
                              [Sequelize.fn('sum', Sequelize.col('quantity')), 'total_quantity'] ],
                        group: [Sequelize.fn('WEEK', Sequelize.col('created_at'))],
                        raw: true
                  });
                  let total_quantity = []
                  withdraw.map(itm => {
                        total_quantity.push(itm.total_quantity)
                  })
                  res.status(200).json(total_quantity);
              }else if(type == "month"){
                  const withdraw = await TokenMintHistory.findAll({
                        attributes: [ 
                              [Sequelize.fn('MONTH', Sequelize.col('created_at')), 'month'],
                              [Sequelize.fn('sum', Sequelize.col('quantity')), 'total_quantity'] ],
                        group: [Sequelize.fn('MONTH', Sequelize.col('created_at'))],
                        raw: true
                  });
                  let total_quantity = []
                  withdraw.map(itm => {
                        total_quantity.push(itm.total_quantity)
                  })
                  res.status(200).json(total_quantity);
              }
            }
      } catch (err) {
          console.log(err);
          res.render('500', { err });
      }
}