const User = require('../models/User');
const UserTokens = require('../models/UserTokens');
const authService = require('../../services/auth.service');
// const bcryptService = require('../../services/bcrypt.service');
const moment = require('moment');
const { Op } = require("sequelize");


exports.index = async (req,res) => {
    res.render('index', {})
};

exports.login = (req,res) => {
    let err = ''
    if(req.query.error == 'email'){
        err = 'You are not authorised to login admin panel.'
    }
    if(req.query.error == 'block'){
        err = 'Your account is blocked. Please contact admin to unblock your account'
    }
    if(req.query.error == 'pass'){
        err = 'Password Incorrect'
    }
    res.render('login/login', { success: '', errors: err })
};
exports.manageUser = async (req, res) => {
    try {
        var success = req.flash('success');
        var error = req.flash('failer');
        const customer = await User.findAll({
            include: [
                {
                    model: UserTokens,
                    required: false,
                }
            ],
            where:{
                status: 1,
                role: 0,
                account_status: {
                    [Op.lt]: 2
                }
            }
        });
        res.render('user/index', { moment: moment, data: customer, success: success, errors: error })
    } catch (err) {
        console.log("err", err)
        res.render('500', { err });
    }
};
exports.view = async (req, res) => {
    try {
        var validationError = req.flash('validationError');
        var form = req.flash('form')[0] || null;
        let id = req.params.id;
        const customer = await User.findOne({
            include: [
                {
                    model: UserTokens,
                    required: false,
                }
            ],
            where:{
                id,
                status: 1
            }
        });
        res.render('user/view', { data: customer, success: '', errors: '', form, validationError })
    } catch (err) {
        console.log("err", err)
        res.render('500', { err });
    }
}
exports.delete = async (req, res) => {
    try {
        let id = req.params.id;
        const user = await User.update({ status: 0 },
            {
                where: {
                    id
                }
            })
        req.flash('success', 'User deleted successfully.');
        res.redirect('/admin/users');
    } catch (err) {
        console.log("err", err)
        res.render('500', { err });
    }
}
exports.block = async (req, res) => {
    try {
        let id = req.params.id;
        const user = await User.update({ account_status: 0 },
            {
                where: {
                    id
                }
            })

        req.flash('success', 'User block successfully.');
        res.redirect('/admin/users');
    } catch (err) {
        console.log("err", err)
        res.render('500', { err });
    }
}
exports.unblock = async (req, res) => {
    try {
        let id = req.params.id;
        const user = await User.update({ account_status: 1 },
            {
                where: {
                    id
                }
            })
        req.flash('success', 'User unblock successfully.');
        res.redirect('/admin/users');
    } catch (err) {
        console.log("err", err)
        res.render('500', { err });
    }
}