const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'admin';
const User = sequelize.define('User', {});

const Admin = sequelize.define('Admin', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    image: {
        type: Sequelize.STRING,
    },
    phone: {
        type: Sequelize.STRING,
    },
    status: {
        type: Sequelize.BOOLEAN
    }

}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

Admin.belongsTo(User, {
    foreignKey: "user_id",
});

// eslint-disable-next-line
Admin.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = Admin;
