const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'cms';

const CMS = sequelize.define('CMS', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    name: {
        type: Sequelize.STRING,
    },
    title: {
        type: Sequelize.STRING,
    },
    content: {
        type: Sequelize.STRING,
    },
    slug: {
        type: Sequelize.STRING,
    },
    status: {
        type: Sequelize.BOOLEAN
    }

}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

CMS.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = CMS;
