const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'support';
const User = sequelize.define('User', {});

const Support = sequelize.define('Support', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: Sequelize.INTEGER,
    },
    issue: {
        type: Sequelize.STRING
    },
    email: {
        type: Sequelize.STRING
    },
    status: {
        type: Sequelize.BOOLEAN
    },
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

Support.belongsTo(User, {
    foreignKey: "user_id",
});

// eslint-disable-next-line
Support.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = Support;
