const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'tokenomics';

const Tokenomics = sequelize.define('Tokenomics', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    token_supply: {
        type: Sequelize.BIGINT
    },
    earn_rate_per_1000_step: {
        type: Sequelize.INTEGER
    },
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

// eslint-disable-next-line
Tokenomics.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = Tokenomics;
