const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'totalIssuesToken';

const TotalIssuesToken = sequelize.define('TotalIssuesToken', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    total_issued: {
        type: Sequelize.BIGINT
    },
    total_supply: {
        type: Sequelize.BIGINT
    },
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

// eslint-disable-next-line
TotalIssuesToken.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = TotalIssuesToken;
