const Sequelize = require('sequelize');
const bcryptService = require('../../services/bcrypt.service');
const sequelize = require('../../config/database');

const tableName = 'users';
const UsersDailySteps = sequelize.define('UsersDailySteps', {});
const UsersDailyAdds = sequelize.define('UsersDailyAdds', {});
const UserTokens = sequelize.define('UserTokens', {});
const TokenMintHistory = sequelize.define('TokenMintHistory', {});
const UserWithdrawals = sequelize.define('UserWithdrawals', {});

const User = sequelize.define('User', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    role: {
        type: Sequelize.DECIMAL,
    },
    name: {
        type: Sequelize.STRING
    },
    email: {
        type: Sequelize.STRING,
        unique: true,
    },
    password: {
        type: Sequelize.STRING,
    },
    two_factor: {
        type: Sequelize.BOOLEAN,
    },
    phone: {
        type: Sequelize.DECIMAL,
    },
    otp: {
        type: Sequelize.STRING
    },
    otp_date: {
        type: Sequelize.DATE
    },
    apple_id: {
        type: Sequelize.STRING
    },
    forgot_password_token: {
        type: Sequelize.STRING,
    },
    total_steps: {
        type: Sequelize.BIGINT,
    },
    mint_address: {
        type: Sequelize.STRING,
    },
    wallet_address: {
        type: Sequelize.STRING,
    },
    is_verify: {
        type: Sequelize.DECIMAL,
    },
    account_status: {
        type: Sequelize.DECIMAL,
    },
    premium_account: {
        type: Sequelize.BOOLEAN,
    },
    status: {
        type: Sequelize.DECIMAL,
    },
}, {
    // hooks, 
    tableName,
    underscored: true,
    freezeTableName: true
});

User.hasMany(UsersDailySteps, {
    foreignKey: 'user_id',
});
User.hasMany(UsersDailyAdds, {
    foreignKey: 'user_id',
});
User.hasMany(UserTokens, {
    foreignKey: 'user_id',
});
User.hasMany(TokenMintHistory, {
    foreignKey: 'user_id',
});
User.hasMany(UserWithdrawals, {
    foreignKey: 'user_id',
});


// eslint-disable-next-line
User.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    delete values.password;
    return values;
};

module.exports = User;
