const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'userTokens';
const User = sequelize.define('User', {});

const UserTokens = sequelize.define('UserTokens', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: Sequelize.INTEGER,
    },
    total_earned: {
        type: Sequelize.FLOAT(20,4)
    },
    total_withdraw: {
        type: Sequelize.FLOAT(20,4)
    },
    onhold: {
        type: Sequelize.FLOAT(20,4)
    },
    current_balance: {
        type: Sequelize.FLOAT(20,4)
    },
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

UserTokens.belongsTo(User, {
    foreignKey: "user_id",
});

// eslint-disable-next-line
UserTokens.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = UserTokens;
