const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'userWithdrawals';
const User = sequelize.define('User', {});

const UserWithdrawals = sequelize.define('UserWithdrawals', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: Sequelize.INTEGER,
    },
    before_withdraw_balance: {
        type: Sequelize.FLOAT(20,4),
    },
    withdraw_amount: {
        type: Sequelize.FLOAT(20,4),
    },
    withdraw_address: {
        type: Sequelize.STRING
    },
    transaction_details: {
        type: Sequelize.STRING
    },
    datetime: {
        type: Sequelize.DATE
    },
    status: {
        type: Sequelize.DECIMAL,
    },
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

UserWithdrawals.belongsTo(User, {
    foreignKey: "user_id",
});

// eslint-disable-next-line
UserWithdrawals.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = UserWithdrawals;
