const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'usersDailyAdds';
const User = sequelize.define('User', {});

const UsersDailyAdds = sequelize.define('UsersDailyAdds', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: Sequelize.INTEGER,
    },
    date: {
        type: Sequelize.DATE
    },
    add_views: {
        type: Sequelize.INTEGER
    },
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

UsersDailyAdds.belongsTo(User, {
    foreignKey: "user_id",
});

// eslint-disable-next-line
UsersDailyAdds.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = UsersDailyAdds;
