const router = require('express').Router();
const User = require('../models/User');
// const Admin = require('../models/Admin');
// const Order = require('../models/Order');
const bcrypt = require('bcryptjs');
// const Notification = require('../models/Notification');

const UserController = require('../controllers/UserController')
const WithdrawalsController = require('../controllers/WithdrawalsController')
const DashboardController = require('../controllers/DashboardController')
const auth = require('../../policies/auth.policy');
const bcryptService = require('../../services/bcrypt.service');
const helperService = require('../../services/helpers.service');

// const { validateCategory, validateCat } = require('../validations/validateCategory.js');

async function isLoggedIn(req, res, next) {
  if (req.session.loggedin) {
    global.user =  req.session.user;
    global.image =  req.session.image;
    return next();
  }
  res.redirect('/admin/login')
}
function isLoggedOut(req, res, next) {
  if (!req.session.loggedin) {
    return next();
  }
  res.redirect('/admin/')
}

router.get("/login", isLoggedOut, (req, res) => UserController.login(req, res))
// dashboard
router.get("/", isLoggedIn, (req, res) => DashboardController.home(req, res))
router.get("/ajax/dashboard", isLoggedIn, DashboardController.ajaxDashboard)

//Login
router.post('/auth', async function (req, res) {

  const { email, password } = req.body;
  if (email && password) {
    try {
      const user = await User.findOne({
        where: {
          email,
          role: 1,
          status: 1,
          is_verify: 1,
          account_status: 1
        }
      });

      if (!user) {
        res.redirect('/admin/login?error=email')
      } else {
        if (bcryptService().comparePassword(password, user.password)) {
          if(user.account_status == 0) {
            res.redirect('/admin/login?error=block')
          }else{
            req.session.loggedin = true;
            req.session.email = email;
            req.session.user = user.name;
            res.redirect('/admin/');
          }
        } else {
        res.redirect('/admin/login?error=pass')
        }
      }

    } catch (err) {
      console.log(err);
      res.render('500', { err });
    }
  }
});
//Logout
router.post("/logout", async function (req, res) {
  req.session.destroy(function (err) {
    if (err) throw err
  })
  res.redirect('/admin/login')
})

//manage users
router.get("/users", isLoggedIn, UserController.manageUser)
router.get("/user/view/:id", isLoggedIn, UserController.view)
router.post("/user/delete/:id", isLoggedIn, UserController.delete)
router.post("/user/block/:id", isLoggedIn, UserController.block)
router.post("/user/unblock/:id", isLoggedIn, UserController.unblock)

//manage withdrawals
router.get("/withdrawals", isLoggedIn, WithdrawalsController.manageWithdrawals)
router.post("/withdrawals/accept/:id", isLoggedIn, WithdrawalsController.acceptWithdraw)
router.post("/withdrawals/cancel/:id", isLoggedIn, WithdrawalsController.cancelWithdraw)


module.exports = router;