const {
    body,
    validationResult
} = require('express-validator');
const validateContactInfo = () => {
    return [
        body('email', 'This field is required!').trim().notEmpty()
        .isEmail().withMessage('Email is not valid'),
        body('phone', 'This field is required!').trim().notEmpty()
        .isNumeric()
        .withMessage('Only Number is Allowed'),
        body('address', 'This field is required!').trim().notEmpty(),
    ];
}
const validateInfo = (req, res, next) => {
    const errors = validationResult(req)
    console.log("req", req.body)
    if (errors.isEmpty()) {
        return next()
    }
    const extractedErrors = []
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));
    
    console.log("extractedErrors=>>>>>>>>>>>>>>>>>", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);
    if (req.params.id) {
        return res.redirect('/admin/info/' + req.params.id)
    }
    return res.redirect('/admin/info')
}
module.exports = {
    validateContactInfo,
    validateInfo
}