const {
    body,
    validationResult
} = require('express-validator');
const User = require('../models/User');
const validateDriver = () => {
    return [
        body('first_name', 'This field is required!').trim().notEmpty()
            .matches(/^[A-Za-z]+$/)
            .withMessage('Name must be alphabetic.'),
        body('last_name', 'This field is required!').trim().notEmpty()
            .matches(/^[A-Za-z]+$/)
            .withMessage('Name must be alphabetic.'),
        body('email', 'This field is required!').trim().notEmpty()
            .isEmail().withMessage('Email is not valid')
            .custom(email => {
                return User.findOne({
                    where: {
                        email: email
                    }
                })
                    .then(user => {
                        console.log("user", user)
                        if (user) {
                            return Promise.reject('Email already in use');
                        }
                    })
            }),
        body('driver_image_base64', 'This field is required!').notEmpty(),
        body('driver_licence_base64', 'This field is required!').notEmpty(),
        body('driver_rc_base64', 'This field is required!').notEmpty(),
        body('password', 'This field is required!').trim().notEmpty()
            .isLength({ min: 8 })
            .withMessage('Password must be greater than 8 characters'),
            // .isStrongPassword({
            //     minLength: 8,
            //     minLowercase: 1,
            //     minUppercase: 1,
            //     minNumbers: 1
            // })
            // .withMessage("Password must be greater than 8 and contain at least one uppercase letter, one lowercase letter, and one number"),
        body('confirm_password', 'This field is required!').trim().notEmpty()
            .custom(async (confirmPassword, { req }) => {
                const password = req.body.password
                if (password !== confirmPassword) {
                    return new Error('Passwords must be same')
                }
            })
            .withMessage("Confirm Password not matched."),
        body('phone', 'This field is required!').trim().notEmpty()
            .isNumeric()
            .withMessage('Phone is not valid'),
        body('address', 'This field is required!').trim().notEmpty()
    ];
}
const validateDriv = (req, res, next) => {
    const errors = validationResult(req)
    console.log("req", req.body)
    if (errors.isEmpty()) {
        return next()
    }
    const extractedErrors = []
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));
    console.log("extractedErrors=>>>>>>>>>>>>>>>>>", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);
    if (req.params.id) {
        return res.redirect('/admin/driver/' + req.params.id)
    }
    return res.redirect('/admin/driver')
}
module.exports = {
    validateDriver,
    validateDriv
}