const {
    body,
    validationResult
} = require('express-validator');
const User = require('../models/User');
const validateEditCustomers = () => {
    return [
        body('first_name', 'This field is required!').trim().notEmpty()
        .matches(/^[A-Za-z ]+$/)
        .withMessage('Name must be alphabetic.'),
        body('last_name', 'This field is required!').trim().notEmpty()
        .matches(/^[A-Za-z]+$/)
        .withMessage('Name must be alphabetic.'),
        body('email', 'This field is required!').trim().notEmpty()
        .isEmail().withMessage('Email is not valid')
        .custom((email, { req }) => {
            var old_email = req.body.old_email;
            if (email != old_email) {
                return User.findOne({
                    where: {
                        email: email
                    }
                })
                    .then(user => {
                        if (user) {
                            return Promise.reject('Email already in use');
                        }
                    })
            }
            return true;
        }),
        // body('address1', 'This field is required!').trim().notEmpty(),
        // body('address2', 'This field is required!').trim().notEmpty(),
        // body('zip', 'This field is required!').trim().notEmpty()
        // .isNumeric().withMessage('Only Number is allowed'),
        body('phone', 'This field is required!').trim().notEmpty()
        .matches(/^[0-9-/]+$/)
        .withMessage('Only Number is Allowed'),
    ];
}
const validateEditCust = (req, res, next) => {
    const errors = validationResult(req)

    var extractedErrors = [], errorFound = false;
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));
    
    var address1Err = {}, address2Err = {} , zipErr = {} ;
    var { address1, address2, zip } = req.body;
    address1.forEach((itm, i) => {
        if (itm == "") {
            address1Err[i] = 'This field is required!';
            errorFound = true;
        }
    })
    // address2.forEach((itm, i) => {
    //     if (itm == "") {
    //         address2Err[i] = 'This field is required!';
    //         errorFound = true;
    //     }
    // })
    zip.forEach((itm, i) => {
        var regex = /^\d{5}$/;

        if (itm == "") {
            zipErr[i] = 'This field is required!';
            errorFound = true;
        }else{
            if (regex.test(itm) == false) {
                zipErr[i] = 'Invalid zip-code!';
                errorFound = true;
            }
        }
    })
    
    if (Object.keys(address1Err).length > 0) {
        extractedErrors.push({ address1Err })
    }
    // if (Object.keys(address2Err).length > 0) {
    //     extractedErrors.push({ address2Err })
    // }
     if (Object.keys(zipErr).length > 0) {
        extractedErrors.push({ zipErr })
    }

    if (errors.isEmpty() && !errorFound) {
        return next()
    }
    console.log("extractedErrors=>>>>>>>>>>>>>>>>>", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);
    if (req.params.id) {
        return res.redirect('/admin/customer/' + req.params.id)
    }
    return res.redirect('/admin/customer')
}
module.exports = {
    validateEditCustomers,
    validateEditCust
}