const {
    body,
    validationResult
} = require('express-validator');
const validateLocation = () => {
    return [
        body('state_id', 'This field is required!').trim().notEmpty(),
        body('name', 'This field is required!').trim().notEmpty()
        .matches(/^[A-Za-z .,^()'_!?><";:`~&@#$%/*|-]+$/)
        .withMessage('Name must be alphabetic.'),
        body('zip_code', 'This field is required!').trim().notEmpty()
        .isNumeric().withMessage('Only Number is allowed'),
    ];
}
const validateLoc = (req, res, next) => {
    const errors = validationResult(req)
    console.log("req", req.body)
    if (errors.isEmpty()) {
        return next()
    }
    const extractedErrors = []
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));

    console.log("extractedErrors=>>>>>>>>>>>>>>>>>", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);
    return res.redirect('/admin/location')
}
module.exports = {
    validateLocation,
    validateLoc
}