const {
    body,
    validationResult
} = require('express-validator');
const validateProducers = () => {
    return [
        body('name', 'This field is required!').trim().notEmpty()
        .matches(/^[A-Za-z .,^()'_!?><";:`~&@#$%/*|-]+$/)
        .withMessage('Name must be alphabetic.'),
        body('base_image', 'This field is required!').trim().notEmpty(),
        body('cover_base_image', 'This field is required!').trim().notEmpty(),
        body('description', 'This field is required!').trim().notEmpty(),
        body('address', 'This field is required!').trim().notEmpty(),
        body('zip', 'This field is required!').trim().notEmpty()
        .matches(/^[0-9]+$/)
        .withMessage('Only Number is allowed'),
    ];
}
const validateProdu = (req, res, next) => {
    const errors = validationResult(req)
    if (errors.isEmpty()) {
        return next()
    }
    const extractedErrors = []
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));
    
    console.log("extractedErrors=>>>>>>>>>>>>>>>>>", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);
    if (req.params.id) {
        return res.redirect('/admin/producer/' + req.params.id)
    }
    return res.redirect('/admin/producer')
}
module.exports = {
    validateProducers,
    validateProdu
}