const {
    body,
    validationResult
} = require('express-validator');
const validateProduct = () => {
    return [
        body('category', 'This field is required!').notEmpty(),
        body('producer_id', 'This field is required!').notEmpty(),
        body('subcategory_id', 'This field is required!').notEmpty(),
        body('name', 'This field is required!').trim().notEmpty()
            .matches(/^[A-Za-z -._,'!&@#$%/*|]+$/)
            .withMessage('Name is not valid.'),
        body('description', 'This field is required!').trim().notEmpty(),
        body('abv', 'This field is required!').trim().notEmpty(),
        body('ibu', 'This field is required!').trim().notEmpty(),
        body('base_image', 'This field is required!').notEmpty(),
    ];
}
const validateProd = (req, res, next) => {
    const errors = validationResult(req)

    var extractedErrors = [], errorFound = false;
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));

    var base_image_NewErr = {}, base_imageErr = {}, packingErr = {}, inStockError = {}, warningLevelError = {}, priceError = {};
    var { base_image_new, base_image_other, packing, in_stock, warning_level, price } = req.body;
    packing.forEach((itm, i) => {
        if (itm == "") {
            packingErr[i] = 'This field is required!';
            errorFound = true;
        }
    })
    in_stock.forEach((itm, i) => {
        if (itm == "") {
            inStockError[i] = 'This field is required!';
            errorFound = true;
        }
    })
    warning_level.forEach((itm, i) => {
        if (itm == "") {
            warningLevelError[i] = 'This field is required!';
            errorFound = true;
        }
    })
    price.forEach((itm, i) => {
        if (itm == "") {
            priceError[i] = 'This field is required!';
            errorFound = true;
        }
    })
    if(base_image_other){
        if(base_image_other.length > 0){
            base_image_other.forEach((itm, i) => {
                if (itm == "") {
                    base_imageErr[i] = 'This field is required!';
                    errorFound = true;
                }
            })
        }else{
            if (base_image_other == "") {
                base_imageErr = 'This field is required!';
                errorFound = true;
            }
        }
    }
    if(base_image_new){
        if(base_image_new.length > 0){
            base_image_new.forEach((itm, i) => {
                if (itm == "") {
                    base_image_NewErr[i] = 'This field is required!';
                    errorFound = true;
                }
            })
        }else{
            if (base_image_new == "") {
                base_image_NewErr = 'This field is required!';
                errorFound = true;
            }
        }
    }
    if (Object.keys(base_imageErr).length > 0) {
        extractedErrors.push({ base_imageErr })
    }
    if (Object.keys(base_image_NewErr).length > 0) {
        extractedErrors.push({ base_image_NewErr })
    }
    if (Object.keys(packingErr).length > 0) {
        extractedErrors.push({ packingErr })
    }
    if (Object.keys(inStockError).length > 0) {
        extractedErrors.push({ inStockError })
    }
    if (Object.keys(warningLevelError).length > 0) {
        extractedErrors.push({ warningLevelError })
    }
    if (Object.keys(priceError).length > 0) {
        extractedErrors.push({ priceError })
    }
    if (errors.isEmpty() && !errorFound) {
        return next()
    }
    console.log("extractedErrors", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);

    if (req.params.id) {
        return res.redirect('/admin/product/' + req.params.id)
    }
    return res.redirect('/admin/product')
}
module.exports = {
    validateProduct,
    validateProd
}