const {
    body,
    validationResult
} = require('express-validator');
const validateState = () => {
    return [
        body('name', 'This field is required!').trim().notEmpty()
        .matches(/^[A-Za-z .,^()'_!?><";:`~&@#$%/*|-]+$/)
        .withMessage('Name must be alphabetic.'),
        body('state_code', 'This field is required!').trim().notEmpty()
        .matches(/^[A-Za-z .,^()'_!?><";:`~&@#$%/*|-]+$/)
    ];
}
const validate = (req, res, next) => {
    const errors = validationResult(req)
    console.log("req", req.body)
    if (errors.isEmpty()) {
        return next()
    }
    const extractedErrors = []
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));

    console.log("extractedErrors=>>>>>>>>>>>>>>>>>", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);
    return res.redirect('/admin/state')
}
module.exports = {
    validateState,
    validate
}