const {
    body,
    validationResult
} = require('express-validator');
const validateSubcategory = () => {
    return [
        body('category_id', 'This field is required!').notEmpty(),
        body('name', 'This field is required!').trim().notEmpty()
        .matches(/^[A-Za-z .,^()'_!?><";:`~&@#$%/*|-]+$/)
        .withMessage('Name must be alphabetic.'),
        body('description', 'This field is required!').trim().notEmpty(),
    ];
}
const validateSubcat = (req, res, next) => {
    const errors = validationResult(req)
    console.log("req", req.body)
    if (errors.isEmpty()) {
        return next()
    }
    const extractedErrors = []
    errors.array({ onlyFirstError: true }).map(err => extractedErrors.push({ [err.param]: err.msg }));
    
    console.log("extractedErrors=>>>>>>>>>>>>>>>>>", extractedErrors)
    req.flash('validationError', extractedErrors);
    req.flash('form', req.body);
    if (req.params.id) {
        return res.redirect('/admin/subcategory/' + req.params.id)
    }
    return res.redirect('/admin/subcategory')
}
module.exports = {
    validateSubcategory,
    validateSubcat
}