const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'tokenMintHistory';
const User = sequelize.define('User', {});

var today = new Date();
var time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();

const TokenMintHistory = sequelize.define('TokenMintHistory', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: Sequelize.INTEGER,
    },
    date: {
        type: Sequelize.DATE
    },
    time: {
        type: Sequelize.TIME,
        defaultValue: time
    },
    quantity: {
        type: Sequelize.FLOAT(10, 4)
    }
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

TokenMintHistory.belongsTo(User, {
    foreignKey: "user_id",
});

// eslint-disable-next-line
TokenMintHistory.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = TokenMintHistory;
