const Sequelize = require('sequelize');

const sequelize = require('../../config/database');

const tableName = 'usersDailySteps';
const User = sequelize.define('User', {});

const UsersDailySteps = sequelize.define('UsersDailySteps', {
    id: {
        type: Sequelize.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    user_id: {
        type: Sequelize.INTEGER,
    },
    date: {
        type: Sequelize.DATE
    },
    steps: {
        type: Sequelize.INTEGER
    },
    remaining_steps: {
        type: Sequelize.INTEGER
    },
}, {
    tableName,
    underscored: true,
    freezeTableName: true
});

UsersDailySteps.belongsTo(User, {
    foreignKey: "user_id",
});

// eslint-disable-next-line
UsersDailySteps.prototype.toJSON = function () {
    const values = Object.assign({}, this.get());
    return values;
};

module.exports = UsersDailySteps;
