const router = require('express').Router();
const UserContoller = require('../controllers/UserController')
const StepCounter = require('../controllers/StepCounter')
// const CategoryController = require('../controllers/CategoryController')
// const OrderController = require('../controllers/OrderController')
// const NotificationController = require('../controllers/NotificationController')
// const StripeController = require('../controllers/StripeController')
const auth = require('../../policies/auth.policy');

router.get('/', (req, res) => { res.send("I'm here") })

// user APIs
router.post('/user/register', UserContoller.register);
router.post('/user/send-two-factor-auth', UserContoller.sendTwoFactorAuthentication);
router.post('/user/verify-two-factor-auth', UserContoller.verifyTwoFactorAuthentication);
router.post('/user/reset-code', UserContoller.resetCode);
router.post('/user/support-screen', UserContoller.supportScreenCode);

// router.post('/user/verify-reset-code', UserContoller.verifyResetCode);
router.post('/user/update-password', UserContoller.changedPassword);
router.post('/user/login', UserContoller.login);
router.get('/user/cms', UserContoller.cms);
router.post('/user/upgrade-account', UserContoller.upgradeAccount);
router.get('/user/profile', UserContoller.profile);
//adds view
router.post('/user/adds-view', UserContoller.adds);

//step counter
router.post('/user/step-count', StepCounter.stepCount);
router.get('/user/get-step-count', StepCounter.getStepCount);
//withdraw 
router.post('/user/withdraw', StepCounter.withdraw);
router.get('/user/get-withdraw', StepCounter.withdrawGetData);
router.post('/user/update-wallet', StepCounter.updateWallet);
router.get('/user/transaction-history', StepCounter.transactionHistory);

//global
router.get('/user/global-statistics', StepCounter.globalStatistics);
router.get('/user/top-25-players', StepCounter.topGlobalPlayers);

router.post('/user/customer-support', UserContoller.customerSupport);
 
// router.post('/customer/update', UserContoller.update);
// router.post('/customer/forgot-password', UserContoller.forgotPassword);
// router.post('/customer/reset-password', UserContoller.resetPassword);
// router.post('/customer/change-password', UserContoller.changePassword);
// router.get('/customer/validate', UserContoller.validate);
// router.post('/customer/add-address', UserContoller.addAddress);
// router.post('/customer/delete-address', UserContoller.deleteAddress);
// router.post('/customer/update-image', UserContoller.updateImage);  // not in collection
// router.post('/customer/google-auth', UserContoller.googleAuth); 
// router.post('/customer/apple-auth', UserContoller.appleAuth); 
// router.post('/customer/check-delivery-address', UserContoller.checkDeliveryAddress);
// router.post('/customer/age-verification', UserContoller.ageVerification);
// router.post('/customer/google-address', UserContoller.addGoogleAddress);

// // product APIs

// router.get('/customer/home', ProductController.home)
// router.get('/customer/all-merch', ProductController.AllMerch)
// router.get('/customer/more-merch', ProductController.moreMerch)
// router.get('/customer/merch-filter', ProductController.filterMerch)
// router.get('/customer/merch-product', ProductController.merchProduct)
// router.get('/customer/more-staff-picks', ProductController.moreStaffPicks)
// router.get('/customer/subcategories', ProductController.subcategories)
// router.get('/customer/all-brands', ProductController.allBrands)
// router.get('/customer/local-brand', ProductController.localBrand)
// router.get('/customer/new-arrivals', ProductController.newArrivals)
// router.get('/customer/products', ProductController.getProducts)
// router.get('/customer/brand-products', ProductController.getBrandsProducts)
// router.get('/customer/local', ProductController.local)


// // order APIs
// router.post('/customer/favorite', OrderController.createFavorite);
// router.post('/customer/remove-favorite', OrderController.removeFavorite);
// router.get('/customer/favorites', OrderController.favorites);
// router.get('/customer/history', OrderController.history);


// // Category APIs
// router.get('/customer/types', CategoryController.getAll);

// // Notification 
// router.post('/customer/add-notification', NotificationController.addNotification);
// router.get('/customer/get-notification', NotificationController.getNotification);

// router.use('*', (req, res, next) => auth(req, res, next))

// router.post('/register', (req, res) => UserContoller().register(req, res));
// router.get('/', (req, res) => UserContoller().getAll(req, res));
// router.put('/:id', (req, res) => UserContoller().update(req, res));

// router.post('/customer/create-checkout-session', StripeController.checkout);
// router.post('/customer/retrieve-session', StripeController.retrieve);

module.exports = router;