const Sequelize = require('sequelize');
const path = require('path');

const connection = require('./connection');

let database;

switch (process.env.NODE_ENV) {
  case 'production':
    database = new Sequelize(
      connection.production.database,
      connection.production.username,
      connection.production.password, {
        host: connection.production.host,
        dialect: connection.production.dialect,
        dialectOptions: {
          useUTC: false, // for reading from database
        },
        pool: {
          max: 5,
          min: 0,
          idle: 10000,
        },
        logging: true,
      },
    );
    break;
  case 'testing':
    database = new Sequelize(
      connection.testing.database,
      connection.testing.username,
      connection.testing.password, {
        host: connection.testing.host,
        dialect: connection.testing.dialect,
        dialectOptions: {
          useUTC: false, // for reading from database
        },
        pool: {
          max: 5,
          min: 0,
          idle: 10000,
        },
        logging: true,
      },
    );
    break;
  default:
    database = new Sequelize(
      connection.development.database,
      connection.development.username,
      connection.development.password, {
        host: connection.development.host,
        dialect: connection.development.dialect,
        dialectOptions: {
          useUTC: false, // for reading from database
        },
        pool: {
          max: 5,
          min: 0,
          idle: 10000,
        },
        storage: path.join(process.cwd(), 'db', 'database.sqlite'),
        logging: true,
      },
    );
}

module.exports = database;
