var express = require('express');
var Sequelize = require('sequelize');
var bodyParser = require('body-parser')
var cors = require('cors')
var path = require('path');
var flash = require('connect-flash');
var session = require('express-session');
// var formidable = require('formidable');
require('dotenv').config()


var app = express();
app.use(cors())
app.use(bodyParser.json({ limit: "50mb", extended: true }))
app.use(bodyParser.urlencoded({ limit: "50mb", extended: true }));
app.use(function (req, res, next) {
  res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
  res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
  next();
});
app.use(session({
  secret: 'Ma"bcz~M>A"8Y6,v',
  resave: true,
  saveUninitialized: true
}));
app.use(flash());
app.use(session({
  cookie: { maxAge: 60000 },
  secret: 'woot',
  resave: false,
  saveUninitialized: false
}));
app.use(express.static(path.join(__dirname, 'public')));
app.set('views', path.join(__dirname, 'admin/views'));
app.set('view engine', 'ejs');
// app.use(formidable)

app.use("/api", require("./api/routes/index"));
app.use("/admin", require("./admin/routes"));
app.get('/', function (req, res) {
  res.end("hello world");
});
app.listen(6900);