const bcrypt = require('bcryptjs');
 
const bcryptService = () => {
  const password = (user) => {
    const salt = bcrypt.genSaltSync();
    const hash = bcrypt.hashSync(user.password, salt);

    return hash;
  };

  const convertPassword = (password) => {
    const salt = bcrypt.genSaltSync();
    const hash = bcrypt.hashSync(password, salt);

    return hash;
  };

  const comparePassword = (pw, hash) => {
    return bcrypt.compareSync(pw, hash)
  }

  return {
    password,
    comparePassword,
    convertPassword,
  };
};

module.exports = bcryptService;
