const nodemailer = require("nodemailer");

const EMAIL_SUBJECTS = {
    "info": "",
    "subscription": "",
    "alert": "",
    "forgot-password": "Forgot Password",
    "verify-account": "Verify Account",
    "withdraw": "Withdrawals",
    "withdraw-accept": "Withdrawal Request Approved",
    "withdraw-cancel": "Withdrawal Request Cancelled",
    "support-ticket": "Support Ticket"
}

exports.sendEmail = (subject, email_to, email_msg) => {
    email_recipients = (typeof email_to == 'Array') ? email_to.join(',') : email_to
    let transporter = nodemailer.createTransport({
        host: "smtp.gmail.com",
        auth: {
            user: process.env.EMAIL_USER,
            pass: process.env.EMAIL_PASS,
        },
    });
    // console.log('process.env.EMAIL_USER', process.env.EMAIL_USER)
    // console.log('process.env.EMAIL_PASS', process.env.EMAIL_PASS)
    transporter.sendMail({
        from: process.env.EMAIL_USER, // sender address
        to: email_recipients, // list of receivers
        subject: EMAIL_SUBJECTS[subject], // Subject line
        html: email_msg, // plain text body
        // html: "<b>Hello world?</b>", // html body
    }, function (err, info) {
        if (err) {
            console.log('Email Error :-( ', err)
        } else {
            console.log('Email Sent :-) ', info.messageId)
        }
    });
}