
const helperService = () => {
    const success = async (data, msg, res) => {
        return res.status(200).json({ success: true, data: data, msg: msg });
    }
    const badRequest = async (data, msg, res) => {
        return res.status(400).json({ success: false, data: data, msg: msg })
    }
    const serverError = async (err, res) => {
        console.log("err", err)
        return res.status(500).json({ success: false, data: [], msg: "Internal Server error." })
    }
    const unauthorized = async (res) => {
        return res.status(401).json({ success: false, data: [], msg: "Unauthorized. Invalid Token!!" })
    }
    const differenceTime = (value) => {
        var date1 = new Date(value);
        var date2 = new Date();
    
        var diff =(date2.getTime() - date1.getTime()) / 1000;
        diff /= 60;
        d = Math.floor(diff/1440); // 60*24
        h = Math.floor((diff-(d*1440))/60);
        m = Math.round(diff%60);
    
        if(d > 0){
            return (d + " d");
        }else if(h > 0){
            return (h + "h");
        }else if(m > 0){
            return (m+"min");
        }else{
            return ("just now");
        }
    }

    const calculateTokenSuppy = (totalToken, totalIssusedToken, step ) => {
        const token = totalToken - totalIssusedToken // 21000000000 - 3000
        if(token > 18000000000 ){
            const max_rate = 1
            const countStepsToken = calculateToken(step,  max_rate)
            return countStepsToken
        }
        else if(token > 15000000000 ){
            const max_rate = .5
            const countStepsToken = calculateToken(step,  max_rate)
            return countStepsToken
        }
        else if(token > 12000000000 ){
            const max_rate = .25
            const countStepsToken = calculateToken(step,  max_rate)
            return countStepsToken
        }
        else if(token > 9000000000 ){
            const max_rate = .125
            const countStepsToken = calculateToken(step,  max_rate)
            return countStepsToken
        }
        else if(token > 6000000000 ){
            const max_rate = .0625
            const countStepsToken = calculateToken(step,  max_rate)
            return countStepsToken
        }
        else if(token > 3000000000 ){
            const max_rate = .0313
            const countStepsToken = calculateToken(step,  max_rate)
            return countStepsToken
        }else{
            const max_rate = .015625
            const countStepsToken = calculateToken(step,  max_rate)
            return countStepsToken
        }
    }
    const calculateToken = (totalSteps, maxRate) => {
        const count = maxRate / 1000 ;
        let totalTokenEarn = count * totalSteps
        totalTokenEarn = parseFloat(totalTokenEarn).toFixed(4)
        return totalTokenEarn
    }
    const limitSteps = (value) => {
        switch(value){
            case 3:
                return 16000
            case 2:
                return 14000
            case 1:
                return 12000
            default:
                return 10000
        }
    }
    return {
        success, badRequest, serverError, unauthorized, differenceTime, calculateTokenSuppy, limitSteps
    };
}

module.exports = helperService;